<?php
header("Content-Type: application/json");

// ✅ Include DB connection
include "../../conn.php"; // Make sure this file defines $conn and sets charset to utf8

// ✅ Fetch latest site message
$sql = "SELECT title, siteMessage, sort, addtime FROM site_messages ORDER BY sort ASC, id DESC LIMIT 1";
$result = $conn->query($sql);

// ✅ Prepare response
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo json_encode([
        "data" => [$row],
        "code" => 0,
        "msg" => "Succeed",
        "msgCode" => 0,
        "serviceNowTime" => date("Y-m-d H:i:s")
    ]);
} else {
    echo json_encode([
        "data" => [],
        "code" => 1,
        "msg" => "No data found",
        "msgCode" => 1,
        "serviceNowTime" => date("Y-m-d H:i:s")
    ]);
}
?>
